/*
 * Copyright (C) 2000-2001 Misha Nasledov <misha@nasledov.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General
 * Public License along with this program; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* taken from gtkhx and modified for hxd/ghx */

#include "hx.h"
#include "hx_gtk.h"
#include "hxd.h"
#include "news15.h"
#include "gtk_hlist.h"
#include "xmalloc.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/time.h>
#include <time.h>
#include "sys_net.h"

#include "newscat.xpm"
#include "newsfld.xpm"

#if defined(CONFIG_ICONV)
#include "conv.h"
#endif

void output_news_thread (struct htlc_conn *htlc, struct news_post *post);
void output_news_dirlist (struct htlc_conn *htlc, struct news_folder *news);
void output_news_catlist (struct htlc_conn *htlc, struct news_group *group);

#ifndef _
#define _(_x) (_x)
#endif

extern u_int8_t *path_to_hldir (const char *path, u_int16_t *hldirlen, int is_file);

void
rcv_task_newscat_list(struct htlc_conn *htlc, char *path)
{
	struct news_group *group = 0;
	struct news_item *ni;
	unsigned char *ptr;
	int p, j;

	/* Taken from fidelio =) */
#define get_pstring(ret) if(*ptr==0){ret=NULL;}else{ret=xmalloc(1+*ptr); \
 memcpy(ret,ptr+1,*ptr); (ret)[*ptr]=0;ptr+=*ptr;} ptr++;

	dh_start(htlc)
		switch (dh_type) {
		case HTLS_DATA_TASKERROR:
			return;
		case HTLS_DATA_NEWS_CATLIST:
			group = xmalloc(sizeof(struct news_group));
			group->path = path;
			ptr = dh_data+4;
			L32NTOH(group->post_count, ptr); ptr += 4;
			ptr += *ptr;
			ptr += 2;
			group->posts = xmalloc(sizeof(struct news_item)*group->post_count);
			for (p = 0, ni = group->posts; p < group->post_count; p++, ni++) {
				L32NTOH(ni->postid, ptr); ptr += 4;
				L16NTOH(ni->date.base_year, ptr); ptr += 2;
				L16NTOH(ni->date.pad, ptr); ptr += 2;
				L32NTOH(ni->date.seconds, ptr); ptr += 4;
				L32NTOH(ni->parentid, ptr); ptr += 8;
				L16NTOH(ni->partcount, ptr); ptr += 2;
				
				get_pstring(ni->subject);
				get_pstring(ni->sender);
				ni->parts = xmalloc(sizeof(struct news_parts)*ni->partcount);
				ni->size = 0;
				for (j = 0; j < ni->partcount; j++) {
					get_pstring(ni->parts[j].mime_type);
					L16NTOH(ni->parts[j].size, ptr); ptr += 2;
					ni->size += ni->parts[j].size;
				}
				ni->group = group;
			}
			break;
		}
	dh_end()

	if (group)
		output_news_catlist(htlc, group);
#if 0
	xfree(path);
	if (group) {
		for (p = 0, ni = group->posts; p < group->post_count; p++, ni++) {
			xfree(ni->subject);
			xfree(ni->sender);
			xfree(ni->parts);
		}
		xfree(group->posts);
		xfree(group);
	}
#endif
}

void
rcv_task_newsfolder_list (struct htlc_conn *htlc, char *path)
{
	struct news_folder *folder = 0;
	struct folder_item *item;
	unsigned int num = 0;

	folder = xmalloc(sizeof(struct news_folder));
	folder->entry = xmalloc(sizeof(struct folder_item));
	folder->path = path;
	folder->num_entries = 0;
	dh_start(htlc)
		switch (dh_type) {
		case HTLS_DATA_TASKERROR:
			xfree(folder->entry);
			xfree(folder);
			return;
		case HTLS_DATA_NEWS_DIRLIST:
			num++;
			folder->entry = xrealloc(folder->entry, sizeof(struct folder_item *)*num);
			item = xmalloc(sizeof(struct folder_item));
			item->type = dh_data[0];
			item->name = xmalloc(dh_len);
			memcpy(item->name, dh_data+1, dh_len-1);
			item->name[dh_len-1] = 0;
			folder->entry[num-1] = item;
			break;
		}
	dh_end()

	folder->num_entries = num;
	output_news_dirlist(htlc, folder);

#if 0
	xfree(folder->path);
	for (num = 0; num < folder->num_entries; num++) {
		xfree(folder->entry[num]->name);
		xfree(folder->entry[num]);
	}
	xfree(folder->entry);
	xfree(folder);
#endif
}

void
rcv_task_news_post (struct htlc_conn *htlc, struct news_item *item)
{
	struct news_post *post = 0;
	u_int32_t tid, nexttid, prevtid, parenttid, nextsubtid;

	dh_start(htlc)
		switch(dh_type) {
		case HTLS_DATA_NEWS_POST:
			post = xmalloc(sizeof(struct news_post));
			post->buf = xmalloc(dh_len+1);
			memcpy(post->buf, dh_data, dh_len);
			post->buf[dh_len] = 0;
			post->buflen = dh_len;
			CR2LF(post->buf, dh_len);
			strip_ansi(post->buf, dh_len);
			break;
		case HTLS_DATA_NEWS_PREVTHREADID:
			dh_getint(prevtid);
			break;
		case HTLS_DATA_NEWS_NEXTTHREADID:
			dh_getint(nexttid);
			break;
		case HTLS_DATA_NEWS_PARENTTHREADID:
			dh_getint(parenttid);
			break;
		case HTLS_DATA_NEWS_NEXTSUBTHREADID:
			dh_getint(nextsubtid);
			break;
		case HTLS_DATA_NEWS_THREADID:
			dh_getint(tid);
			break;
		case HTLS_DATA_NEWS_SUBJECT:
		case HTLS_DATA_NEWS_POSTER:
		case HTLS_DATA_NEWS_MIMETYPE:
		case HTLS_DATA_NEWS_DATE:
			break;
		} 
	dh_end()

	if (!post)
		return;

	post->item = item;
	output_news_thread(htlc, post);
	xfree(post->buf);
	xfree(post);
}

void
hx_news15_get_post (struct htlc_conn *htlc, struct news_item *item)
{
	u_int8_t *hldir;
	u_int16_t hldirlen;
	u_int32_t postid;

	hldir = path_to_hldir(item->group->path, &hldirlen, 0);
	task_new(htlc, rcv_task_news_post, item, 0, "news_post");

	postid = htonl(item->postid);
	hlwrite(htlc, HTLC_HDR_NEWS_GETTHREAD, 0, 3,
			HTLC_DATA_NEWS_DIR, hldirlen, hldir,
			HTLC_DATA_NEWS_THREADID, 4, &postid,
			HTLC_DATA_NEWS_MIMETYPE, strlen(item->parts[0].mime_type),
			item->parts[0].mime_type);
}

void
hx_news15_cat_list (struct htlc_conn *htlc, char *path)
{
	u_int8_t *hldir;
	u_int16_t hldirlen;
	char *cpath;

	cpath = xmalloc(strlen(path)+1);
	strcpy(cpath, path);
	hldir = path_to_hldir(path, &hldirlen, 0);
	task_new(htlc, rcv_task_newscat_list, cpath, 0, "news_category");
	hlwrite(htlc, HTLC_HDR_NEWS_LISTCATEGORY, 0, 1, 
		HTLC_DATA_NEWS_DIR, hldirlen, hldir);
	xfree(hldir);
}

void
hx_news15_fldr_list (struct htlc_conn *htlc, char *path)
{
	u_int8_t *hldir;
	u_int16_t hldirlen;
	char *pathn;

	pathn = xmalloc(strlen(path)+1);
	strcpy(pathn, path);
	hldir = path_to_hldir(path, &hldirlen, 0);
	task_new(htlc, rcv_task_newsfolder_list, pathn, 0, "news_folder");
	hlwrite(htlc, HTLC_HDR_NEWS_LISTDIR, 0, 1, 
		HTLC_DATA_NEWS_DIR, hldirlen, hldir);
	xfree(hldir);
}

void
hx_news15_post_thread (struct htlc_conn *htlc, char *path, char *subject,
		       u_int32_t threadid, char *text)
{
	u_int8_t *hldir;
	u_int16_t hldirlen;
	u_int32_t parent = 0;
	u_int32_t ntid;

	hldir = path_to_hldir(path, &hldirlen, 0);
	task_new(htlc, 0, 0, 0, "news15_post");
	ntid = htonl(threadid);
	hlwrite(htlc, HTLC_HDR_NEWS_POSTTHREAD, 0, 6,
		HTLC_DATA_NEWS_DIR, hldirlen, hldir, 
		HTLC_DATA_NEWS_PARENTTHREADID, 4, &parent,
		HTLC_DATA_NEWS_MIMETYPE, 10, "text/plain", 
		HTLC_DATA_NEWS_SUBJECT, strlen(subject), subject,
		HTLC_DATA_NEWS_POST, strlen(text), text,
		HTLC_DATA_NEWS_THREADID, 4, &ntid);
	xfree(hldir);
}

struct gnews_folder {
	struct ghtlc_conn *ghtlc;
	GtkWidget *window;
	GtkWidget *news_list;
	gint row, col;
	struct news_folder *news;
	struct gnews_folder *next, *prev;
};

struct gnews_folder *gfnews_list = NULL;

struct gnews_folder *gfnews_with_hlist (GtkWidget *hlist);

static void
newsf_clicked (GtkWidget *widget, GdkEventButton *event)
{
	struct ghtlc_conn *ghtlc;
	struct gnews_folder *gfnews;
	int row, col;

	gfnews = gfnews_with_hlist(widget);
	if (!gfnews)
		return;

	ghtlc = gfnews->ghtlc;
	gtk_hlist_get_selection_info(GTK_HLIST(widget), event->x, event->y, &row, &col);
	if (event->type == GDK_2BUTTON_PRESS) {
		struct folder_item *item = gtk_hlist_get_row_data(GTK_HLIST(widget), gfnews->row);
		if (item) {
			char path[4096];

			sprintf(path, "%s/%s", gfnews->news->path, item->name);
			if (item->type == 1)
				hx_news15_fldr_list(ghtlc->htlc, path);
			else
				hx_news15_cat_list(ghtlc->htlc, path);
		}
	} else {
		gfnews->row = row;
		gfnews->col = col;
	}
}

struct gnews_folder *
gfnews_with_hlist (GtkWidget *hlist)
{
	struct gnews_folder *gfnews;

	for (gfnews = gfnews_list; gfnews; gfnews = gfnews->prev) {
		if (gfnews->news_list == hlist) {
			return gfnews;
		}
	}

	return 0;
}

struct gnews_folder *
gfnews_with_path (char *path)
{
	struct gnews_folder *gfnews;

	for (gfnews = gfnews_list; gfnews; gfnews = gfnews->prev) {
		if (!strcmp(gfnews->news->path, path)) {
			return gfnews;
		}
	}

	return 0;
}

void
delete_gfnews (struct gnews_folder *gfnews)
{
	if (gfnews->next)
		gfnews->next->prev = gfnews->prev;
	if (gfnews->prev)
		gfnews->prev->next = gfnews->next;
	if (gfnews == gfnews_list)
		gfnews_list = gfnews->prev;
	xfree(gfnews);
}

void
destroy_gfnews_browser(GtkWidget *widget, gpointer data)
{
	struct gnews_folder *gfnews = gtk_object_get_data(GTK_OBJECT(widget), "gfnews");

	delete_gfnews(gfnews);
	gtk_widget_destroy(widget);
}

struct gnews_folder *
create_gfnews_window (struct ghtlc_conn *ghtlc, struct news_folder *news)
{
	struct gnews_folder *gfnews = xmalloc(sizeof(struct gnews_folder));
	GtkWidget *news_window;
	GtkWidget *news_list;
	GtkWidget *news_scroll;
	GtkWidget *topframe;
	GtkWidget *hbuttonbox;
	GtkWidget *vbox;
	GtkStyle *style;

	gfnews = xmalloc(sizeof(struct gnews_folder));
	memset(gfnews, 0, sizeof(struct gnews_folder));
	gfnews->ghtlc = ghtlc;
	gfnews->prev = 0;
	gfnews->next = 0;
	gfnews->news = news;

	if (gfnews_list) {
		gfnews_list->next = gfnews;
		gfnews->prev = gfnews_list;
	}

	news_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(news_window), 1, 1, 0);

	gtk_widget_realize(news_window);
	style = gtk_widget_get_style(news_window);
	gtk_widget_set_usize(news_window, 264, 400);
	gtk_window_set_title(GTK_WINDOW(news_window), news->path);
	gtk_object_set_data(GTK_OBJECT(news_window), "gfnews", gfnews);
	gtk_signal_connect(GTK_OBJECT(news_window), "delete_event", 
			   GTK_SIGNAL_FUNC(destroy_gfnews_browser), 0);

	news_scroll = gtk_scrolled_window_new(0, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(news_scroll), 
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	news_list = gtk_hlist_new(1);
	gtk_hlist_set_column_width(GTK_HLIST(news_list), 0, 64);
/*	gtk_hlist_set_column_width(GTK_HLIST(news_list), 1, 240); */
	gtk_hlist_set_row_height(GTK_HLIST(news_list), 18);
	gtk_hlist_set_shadow_type(GTK_HLIST(news_list), GTK_SHADOW_NONE);
	gtk_hlist_set_column_justification(GTK_HLIST(news_list), 0, GTK_JUSTIFY_LEFT);
	gtk_signal_connect(GTK_OBJECT(news_list), "button_press_event", 
			   GTK_SIGNAL_FUNC(newsf_clicked), 0);

	topframe = gtk_frame_new(0);
	gtk_widget_set_usize(topframe, -2, 30);
	gtk_frame_set_shadow_type(GTK_FRAME(topframe), GTK_SHADOW_OUT);

	hbuttonbox = gtk_hbox_new(0,0);

	vbox = gtk_vbox_new(0, 0);
	gtk_widget_set_usize(vbox, 240, 400);
	gtk_container_add(GTK_CONTAINER(topframe), hbuttonbox);
	gtk_box_pack_start(GTK_BOX(vbox), topframe, 0, 0, 0);
	gtk_container_add(GTK_CONTAINER(news_scroll), news_list);
	gtk_box_pack_start(GTK_BOX(vbox), news_scroll, 1, 1, 0);
	gtk_container_add(GTK_CONTAINER(news_window), vbox);

	gfnews->window = news_window;
	gfnews->news_list = news_list;
	gtk_widget_show_all(news_window);
	keyaccel_attach(ghtlc, news_window);
	gfnews_list = gfnews;

	return gfnews;
}

void
output_news_dirlist (struct htlc_conn *htlc, struct news_folder *news)
{
	struct ghtlc_conn *ghtlc;
	struct gnews_folder *gfnews;
	GtkWidget *news_list;
	unsigned int row, i;
	GdkPixmap *icon;
	GdkBitmap *mask;
	GtkStyle *style;
	GdkColor col = {0,0,0,0};

	ghtlc = ghtlc_conn_with_htlc(htlc);
	if (!ghtlc)
		return;
	gfnews = gfnews_with_path(news->path);
	if (!gfnews) {
		gfnews = create_gfnews_window(ghtlc, news);
	}
	news_list = gfnews->news_list;

	style = gtk_widget_get_style(news_list);

	gtk_hlist_clear(GTK_HLIST(news_list));

	gtk_hlist_freeze(GTK_HLIST(news_list));
	for (i = 0; i < news->num_entries; i++) {
		struct folder_item *item = news->entry[i];
		gchar *nulls[2] = {0, 0};
		
		/* type 1 is folder */
		/* other is category */
		row = gtk_hlist_append(GTK_HLIST(news_list), nulls);
		gtk_hlist_set_row_data(GTK_HLIST(news_list), row, item);
		icon = gdk_pixmap_create_from_xpm_d(gfnews->window->window,
						&mask,
						&style->bg[GTK_STATE_NORMAL],
						item->type == 1 ? 
						newsfld_xpm : newscat_xpm);
#if defined(CONFIG_ICONV)
{
	size_t out_len, in_len;
	char *out_p, *in_p;

	in_p = (char *)item->name;
	in_len = strlen(item->name);
	out_len = convbuf(g_encoding, g_server_encoding, in_p, in_len, &out_p);
	if (out_len) {
		gtk_hlist_set_pixtext(GTK_HLIST(news_list), row, 0, out_p, 34, icon, mask);
		xfree(out_p);
	} else {
		gtk_hlist_set_pixtext(GTK_HLIST(news_list), row, 0, item->name, 34, icon, mask);
	}
}
#else
		gtk_hlist_set_pixtext(GTK_HLIST(news_list), row, 0, item->name, 34, icon, mask);
#endif
		gtk_hlist_set_foreground(GTK_HLIST(news_list), row, &col);
	}
	gtk_hlist_thaw(GTK_HLIST(news_list));
}

struct gnews_catalog {
	struct ghtlc_conn *ghtlc;
	struct news_group *group;
	struct gnews_catalog *next, *prev;
	GtkWidget *window;
	GtkWidget *news_tree;
	GtkWidget *news_text;
	GtkWidget *authorlbl, *subjectlbl, *datelbl;
	GtkCTreeNode *row;
};

struct gnews_catalog *gcnews_list = NULL;

struct gnews_catalog *
gcnews_with_path(char *path)
{
	struct gnews_catalog *gcnews;

	for (gcnews = gcnews_list; gcnews; gcnews = gcnews->prev) {
		if (!strcmp(path, gcnews->group->path)) {
			return gcnews;
		}
	}
	return 0;
}

struct gnews_catalog *
gcnews_with_group (struct news_group *group)
{
	struct gnews_catalog *gcnews;

	for (gcnews = gcnews_list; gcnews; gcnews = gcnews->prev) {
		if (group == gcnews->group) {
			return gcnews;
		}
	}

	return 0;
}

void
delete_gcnews (struct gnews_catalog *gcnews)
{
	if (gcnews->next)
		gcnews->next->prev = gcnews->prev;
	if (gcnews->prev)
		gcnews->prev->next = gcnews->next;
	if (gcnews == gcnews_list)
		gcnews_list = gcnews->prev;
	xfree(gcnews);
}

static void
destroy_gcnews_browser (GtkWidget *widget, gpointer data)
{
	struct gnews_catalog *gcnews = gtk_object_get_data(GTK_OBJECT(widget), "gcnews");

	delete_gcnews(gcnews);
	gtk_widget_destroy(widget);
}

void
newsc_clicked (GtkCTree *ctree, GList *node, gint column, struct gnews_catalog *gcnews)
{
	struct ghtlc_conn *ghtlc;
	struct news_item *item = gtk_ctree_node_get_row_data(ctree, (GtkCTreeNode *)node);

	ghtlc = gcnews->ghtlc;
	hx_news15_get_post(ghtlc->htlc, item);
	gcnews->row = (GtkCTreeNode *)node;
}

void
news15_do_reply (GtkWidget *btn, struct gnews_catalog *gcnews)
{
	struct ghtlc_conn *ghtlc;
	GtkWidget *text = gtk_object_get_data(GTK_OBJECT(btn), "text");
	GtkWidget *reply = gtk_object_get_data(GTK_OBJECT(btn), "reply");
	GtkWidget *subject = gtk_object_get_data(GTK_OBJECT(btn), "subject");
	GtkWidget *window = gtk_object_get_data(GTK_OBJECT(btn), "window");
	char *textbuf = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
	u_int32_t postid = atoi(gtk_entry_get_text(GTK_ENTRY(reply)));
	char *subjectbuf = gtk_entry_get_text(GTK_ENTRY(subject));

	ghtlc = gcnews->ghtlc;
	hx_news15_post_thread(ghtlc->htlc, gcnews->group->path, subjectbuf,
			      postid, textbuf);

	gtk_widget_destroy(window);
}

void
news15_cancel_post(GtkWidget *btn, GtkWidget *window)
{
	gtk_widget_destroy(window);
}

void
news15_reply (GtkWidget *btn, struct gnews_catalog *gcnews)
{
	struct ghtlc_conn *ghtlc;
	struct news_item *item = 0;
	GtkWidget *window;
	GtkWidget *inreplyto;
	GtkWidget *replylbl;
	GtkWidget *subject;
	GtkWidget *subjectlbl;
	GtkWidget *text;
	GtkWidget *textlbl;
	GtkWidget *vscroll;
	GtkWidget *post, *cancel;
	GtkWidget *hbox, *vbox;
	GtkWidget *table;

	ghtlc = gcnews->ghtlc;
	if (gcnews->row) {
		item = gtk_ctree_node_get_row_data(
			GTK_CTREE(gcnews->news_tree), gcnews->row);
	}

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(window, 320, 250);
	gtk_window_set_title(GTK_WINDOW(window), _("Post News (1.5+)"));
	gtk_container_border_width(GTK_CONTAINER(window), 5);

	vbox = gtk_vbox_new(0,0);
	table = gtk_table_new(3, 2, 0);

	replylbl = gtk_label_new("In Reply To Post #: ");
	inreplyto = gtk_entry_new();
	if (item) {
		char *buf = g_strdup_printf("%d", item->postid);
		
		gtk_entry_set_text(GTK_ENTRY(inreplyto), buf);
		g_free(buf);
	}

	gtk_table_attach(GTK_TABLE(table), replylbl, 0, 1, 0, 1, GTK_EXPAND|GTK_FILL, 0, 0, 0);
	gtk_table_attach(GTK_TABLE(table), inreplyto, 1, 2, 0, 1, GTK_EXPAND|GTK_FILL, 0, 0, 0);

	subjectlbl = gtk_label_new("Subject: ");
	subject = gtk_entry_new();

	if (item) {
		if (strncasecmp(item->subject, "re:", 3)) {
			char *buf = g_strdup_printf("Re: %s", item->subject);
			gtk_entry_set_text(GTK_ENTRY(subject), buf);
			g_free(buf);
		}
		else {
			gtk_entry_set_text(GTK_ENTRY(subject), item->subject);
		}
	}

	gtk_table_attach(GTK_TABLE(table), subjectlbl, 0, 1, 1, 2, GTK_EXPAND|GTK_FILL, 0, 0, 0);
	gtk_table_attach(GTK_TABLE(table), subject, 1, 2, 1, 2, GTK_EXPAND|GTK_FILL, 0, 0, 0);

	textlbl = gtk_label_new("Body: ");
	
	gtk_table_attach(GTK_TABLE(table), textlbl, 0, 1, 2, 3, GTK_EXPAND|GTK_FILL, 0, 0, 0);

	hbox = gtk_hbox_new(0, 0);
	text = gtk_text_new(0, 0);
	gtk_editable_set_editable(GTK_EDITABLE(text), 1);
	vscroll = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);

	gtk_box_pack_start(GTK_BOX(hbox), text, 1, 1, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vscroll, 0, 0, 0);

	gtk_box_pack_start(GTK_BOX(vbox), table, 0, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 10);

	hbox = gtk_hbox_new(1, 0);

	post = gtk_button_new_with_label("Post");
	gtk_object_set_data(GTK_OBJECT(post), "text", text);
	gtk_object_set_data(GTK_OBJECT(post), "reply", inreplyto);
	gtk_object_set_data(GTK_OBJECT(post), "subject", subject);
	gtk_object_set_data(GTK_OBJECT(post), "window", window);
	gtk_signal_connect(GTK_OBJECT(post), "clicked", GTK_SIGNAL_FUNC(news15_do_reply), gcnews);

	cancel = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(news15_cancel_post), 
					   window);

	gtk_box_pack_start(GTK_BOX(hbox), post, 0, 0, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cancel, 0, 0, 0);

	gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 0);

	gtk_container_add(GTK_CONTAINER(window), vbox);
	keyaccel_attach(ghtlc, window);
	gtk_widget_show_all(window);
}

void
news15_do_post (GtkWidget *btn, struct gnews_catalog *gcnews)
{
	struct ghtlc_conn *ghtlc;
	GtkWidget *text = gtk_object_get_data(GTK_OBJECT(btn), "text");
	GtkWidget *subject = gtk_object_get_data(GTK_OBJECT(btn), "subject");
	GtkWidget *window = gtk_object_get_data(GTK_OBJECT(btn), "window");
	char *textbuf = gtk_editable_get_chars(GTK_EDITABLE(text), 0, -1);
	char *subjectbuf = gtk_entry_get_text(GTK_ENTRY(subject));

	ghtlc = gcnews->ghtlc;
	hx_news15_post_thread(ghtlc->htlc, gcnews->group->path, subjectbuf, 0, textbuf);

	gtk_widget_destroy(window);
}

void
news15_post (GtkWidget *btn, struct gnews_catalog *gcnews)
{
	struct ghtlc_conn *ghtlc;
	GtkWidget *window;
	GtkWidget *subject;
	GtkWidget *subjectlbl;
	GtkWidget *text;
	GtkWidget *textlbl;
	GtkWidget *vscroll;
	GtkWidget *post, *cancel;
	GtkWidget *hbox, *vbox;
	GtkWidget *table;

	ghtlc = gcnews->ghtlc;
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(window, 320, 250);
	gtk_window_set_title(GTK_WINDOW(window), _("Post News (1.5+)"));
	gtk_container_border_width(GTK_CONTAINER(window), 5);

	vbox = gtk_vbox_new(0,0);
	table = gtk_table_new(2, 2, 0);

	subjectlbl = gtk_label_new("Subject: ");
	subject = gtk_entry_new();

	gtk_table_attach(GTK_TABLE(table), subjectlbl, 0, 1, 0, 1, GTK_EXPAND|GTK_FILL, 0, 0, 0);
	gtk_table_attach(GTK_TABLE(table), subject, 1, 2, 0, 1, GTK_EXPAND|GTK_FILL, 0, 0, 0);

	textlbl = gtk_label_new("Body: ");
	
	gtk_table_attach(GTK_TABLE(table), textlbl, 0, 1, 1, 2, GTK_EXPAND|GTK_FILL, 0, 0, 0);

	hbox = gtk_hbox_new(0, 0);
	text = gtk_text_new(0, 0);
	gtk_editable_set_editable(GTK_EDITABLE(text), 1);
	vscroll = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);

	gtk_box_pack_start(GTK_BOX(hbox), text, 1, 1, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vscroll, 0, 0, 0);

	gtk_box_pack_start(GTK_BOX(vbox), table, 0, 0, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 10);

	hbox = gtk_hbox_new(1, 0);

	post = gtk_button_new_with_label("Post");
	gtk_object_set_data(GTK_OBJECT(post), "text", text);
	gtk_object_set_data(GTK_OBJECT(post), "subject", subject);
	gtk_object_set_data(GTK_OBJECT(post), "window", window);
	gtk_signal_connect(GTK_OBJECT(post), "clicked", GTK_SIGNAL_FUNC(news15_do_post), gcnews);

	cancel = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(news15_cancel_post), 
					   window);

	gtk_box_pack_start(GTK_BOX(hbox), post, 0, 0, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cancel, 0, 0, 0);

	gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 0);

	gtk_container_add(GTK_CONTAINER(window), vbox);
	keyaccel_attach(ghtlc, window);
	gtk_widget_show_all(window);
}

struct gnews_catalog *
create_gcnews_window (struct ghtlc_conn *ghtlc, struct news_group *group)
{
	struct gnews_catalog *gcnews;
	GtkWidget *news_window;
	GtkWidget *hpaned1;
	GtkWidget *vbox1;
	GtkWidget *hbuttonbox1;
	GtkWidget *refreshbtn;
	GtkWidget *postbtn;
	GtkWidget *replybtn;
	GtkWidget *alignment1;
	GtkWidget *news_tree;
	GtkWidget *vbox2;
	GtkWidget *authorlbl;
	GtkWidget *datelbl;
	GtkWidget *subjectlbl;
	GtkWidget *scrolledwindow1;
	GtkWidget *news_text;
	GtkWidget *scrolledwindow2;
	GtkWidget *viewport1;
	GtkWidget *topframe;
	GtkStyle *style;

	gcnews = xmalloc(sizeof(struct gnews_catalog));
	memset(gcnews, 0, sizeof(struct gnews_catalog));
	gcnews->ghtlc = ghtlc;
	gcnews->prev = gcnews_list;
	gcnews->next = 0;
	gcnews->group = group;

	if (gcnews_list) {
		gcnews_list->next = gcnews;
	}

	news_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(news_window), 1, 1, 0);
	gtk_widget_realize(news_window);
	style = gtk_widget_get_style(news_window);
	gtk_widget_set_usize(news_window, 570, 375); 
	gtk_window_set_title(GTK_WINDOW(news_window), group->path);
	gtk_object_set_data(GTK_OBJECT(news_window), "gcnews", gcnews);
	gtk_signal_connect(GTK_OBJECT(news_window), "delete_event", 
			   GTK_SIGNAL_FUNC(destroy_gcnews_browser), 0);

	hpaned1 = gtk_hpaned_new();
	gtk_container_add(GTK_CONTAINER(news_window), hpaned1);
	gtk_container_set_border_width(GTK_CONTAINER(hpaned1), 4);
	gtk_paned_set_position(GTK_PANED (hpaned1), 285);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_paned_pack1(GTK_PANED (hpaned1), vbox1, FALSE, TRUE);

	topframe = gtk_frame_new(0);
	gtk_widget_set_usize(topframe, -2, 30);
	gtk_frame_set_shadow_type(GTK_FRAME(topframe), GTK_SHADOW_OUT);
	gtk_box_pack_start(GTK_BOX(vbox1), topframe, 0, 0, 0);

	hbuttonbox1 = gtk_hbutton_box_new();
//	gtk_box_pack_start(GTK_BOX(vbox1), hbuttonbox1, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(topframe), hbuttonbox1);

	refreshbtn = gtk_button_new_with_label("Refresh");
	gtk_container_add(GTK_CONTAINER(hbuttonbox1), refreshbtn);
//	GTK_WIDGET_SET_FLAGS (refreshbtn, GTK_CAN_DEFAULT);

	postbtn = gtk_button_new_with_label("Post");
	gtk_container_add(GTK_CONTAINER(hbuttonbox1), postbtn);
//	GTK_WIDGET_SET_FLAGS (postbtn, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(postbtn), "clicked",
			   GTK_SIGNAL_FUNC(news15_post), gcnews);

	replybtn = gtk_button_new_with_label("Reply");
	gtk_container_add(GTK_CONTAINER(hbuttonbox1), replybtn);
//	GTK_WIDGET_SET_FLAGS (replybtn, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(replybtn), "clicked",
			   GTK_SIGNAL_FUNC(news15_reply), gcnews);

	alignment1 = gtk_alignment_new(0.5, 0.5, 1, 1);
	gtk_box_pack_start(GTK_BOX(vbox1), alignment1, TRUE, TRUE, 0);

	scrolledwindow2 = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(alignment1), scrolledwindow2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	viewport1 = gtk_viewport_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolledwindow2), viewport1);
	
	news_tree = gtk_ctree_new(1, 0);
	gtk_clist_set_row_height(GTK_CLIST(news_tree), 18); 
	gtk_clist_set_shadow_type(GTK_CLIST(news_tree), GTK_SHADOW_NONE);
	gtk_signal_connect(GTK_OBJECT(news_tree), "tree_select_row", 
					   GTK_SIGNAL_FUNC(newsc_clicked), gcnews);
	gtk_container_add(GTK_CONTAINER(viewport1), news_tree);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_paned_pack2(GTK_PANED (hpaned1), vbox2, TRUE, TRUE);

	authorlbl = gtk_label_new("Author: ");
	gtk_label_set_justify(GTK_LABEL(authorlbl), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(vbox2), authorlbl, 0, 1, 0);

	datelbl = gtk_label_new("Date: ");
	gtk_label_set_justify(GTK_LABEL(datelbl), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(vbox2), datelbl, 0, 1, 0);
	
	subjectlbl = gtk_label_new("Subject: ");
	gtk_label_set_justify(GTK_LABEL(subjectlbl), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(vbox2), subjectlbl, 0, 1, 0);
	
	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_box_pack_start(GTK_BOX(vbox2), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	
	news_text = gtk_text_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), news_text);
	gtk_widget_show_all(news_window);

	gcnews->window = news_window;
	gcnews->news_tree = news_tree;
	gcnews->news_text = news_text;
	gcnews->subjectlbl = subjectlbl;
	gcnews->datelbl = datelbl;
	gcnews->authorlbl = authorlbl;
	gcnews_list = gcnews;

	keyaccel_attach(ghtlc, news_window);

	return gcnews;
}

void
output_news_catlist (struct htlc_conn *htlc, struct news_group *group)
{
	struct ghtlc_conn *ghtlc;
	struct gnews_catalog *gcnews;
	GtkCTreeNode *parent;
	int i;

	ghtlc = ghtlc_conn_with_htlc(htlc);
	if (!ghtlc)
		return;
	gcnews = gcnews_with_path(group->path);
	if (!gcnews) {
		if (!(gcnews = create_gcnews_window(ghtlc, group))) {
			return;
		}
	}

	gtk_clist_clear(GTK_CLIST(gcnews->news_tree));
	gtk_clist_freeze(GTK_CLIST(gcnews->news_tree));
	for (i = 0; i < group->post_count; i++) {
		struct news_item *item = &(group->posts[i]);
		int j;
		parent = 0;

		if (!item)
			continue;
		for (j = 0; j < group->post_count; j++) {
			if (group->posts[j].postid == item->parentid) {
				parent = group->posts[j].node;
				break;
			}
		}

#if defined(CONFIG_ICONV)
{
	size_t out_len, in_len;
	char *out_p, *in_p;

	in_p = (char *)item->subject;
	in_len = strlen(item->subject);
	out_len = convbuf(g_encoding, g_server_encoding, in_p, in_len, &out_p);
	if (out_len) {
		item->node = gtk_ctree_insert_node(GTK_CTREE(gcnews->news_tree), 
						   parent, 0, &out_p, 0, 0, 0,
						   0, 0, 0, 0);
		xfree(out_p);
	} else {
		item->node = gtk_ctree_insert_node(GTK_CTREE(gcnews->news_tree), 
						   parent, 0, &item->subject, 0, 0, 0,
						   0, 0, 0, 0);
	}
}
#else
		item->node = gtk_ctree_insert_node(GTK_CTREE(gcnews->news_tree), 
						   parent, 0, &item->subject, 0, 0, 0,
						   0, 0, 0, 0);
#endif
		gtk_ctree_node_set_row_data(GTK_CTREE(gcnews->news_tree), item->node, item);
	}
	gtk_clist_thaw(GTK_CLIST(gcnews->news_tree));
}
 
static time_t
date_to_unix (struct date_time *dt)
{
	/* check if the year is after the epoch */
	if (dt->base_year >= 1970) {
		struct tm timetm;
		time_t timet;
		
		memset(&timetm, 0, sizeof(struct tm));
		/* the 24*3600 thing is a hack for a weird bug
			where the date would be displayed one day behind from
			the actual date ... quite odd */
		timetm.tm_sec = dt->seconds+(24*3600);
		timetm.tm_year = (dt->base_year-1900);
		timet =  mktime(&timetm);	
		return timet;
	} else {
		/* crackhead base_year detected */
		if (dt->base_year == 1904)
 			return dt->seconds-2082844800U;
	}
	
	return 0;
}

void
output_news_thread (struct htlc_conn *htlc, struct news_post *post)
{
	struct ghtlc_conn *ghtlc;
	struct gnews_catalog *gcnews = gcnews_with_group(post->item->group);
	struct news_item *item = post->item;
	time_t timet;

	ghtlc = ghtlc_conn_with_htlc(htlc);
	if (!ghtlc)
		return;
	if (!gcnews) {
		return;
	}

	timet = date_to_unix(&item->date);

	gtk_editable_delete_text(GTK_EDITABLE(gcnews->news_text), 0, -1);
	if (item) {
		char *date = g_strdup_printf("Date: %s", ctime(&timet));

		/* get rid of the line break ctime() adds in */
		date[strlen(date)-1] = '\0';

		/* preliminary post thread displaying code */
		if (item->sender) {
			char *str = g_strdup_printf("Author: %s", item->sender);
			gtk_label_set_text(GTK_LABEL(gcnews->authorlbl), str);
			g_free(str);
		}
		if (item->subject) {
			char *str = g_strdup_printf("Subject: %s", item->subject);
			gtk_label_set_text(GTK_LABEL(gcnews->subjectlbl), str);
			g_free(str);
		}
		gtk_label_set_text(GTK_LABEL(gcnews->datelbl), date);
		g_free(date);
	}

#if defined(CONFIG_ICONV)
{
	size_t out_len, in_len;
	char *out_p, *in_p;

	in_p = (char *)post->buf;
	in_len = post->buflen;
	out_len = convbuf(g_encoding, g_server_encoding, in_p, in_len, &out_p);
	if (out_len) {
		gtk_text_insert(GTK_TEXT(gcnews->news_text), 0, 0, 0, out_p, out_len);
		xfree(out_p);
		return;
	}
}
#endif
	/* output the contents of the post */
 	gtk_text_insert(GTK_TEXT(gcnews->news_text), 0, 0, 0, post->buf, strlen(post->buf));
}

void
open_tnews (gpointer data)
{
	struct ghtlc_conn *ghtlc = (struct ghtlc_conn *)data;
	u_int8_t *hldir;
	u_int16_t hldirlen;
	char *path;

	path = xstrdup("/");
	hldir = path_to_hldir(path, &hldirlen, 0);
	task_new(ghtlc->htlc, rcv_task_newsfolder_list, path, 0, "news_folder");
	//hlwrite(ghtlc->htlc, HTLC_HDR_NEWS_LISTDIR, 0, 1, 
	//	HTLC_DATA_NEWS_DIR, hldirlen, hldir);
	hlwrite(ghtlc->htlc, HTLC_HDR_NEWS_LISTDIR, 0, 0);
}
